/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.tasklet.xport.monad;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.Connection;
import com.ibm.hwmca.fw.connmgr.ConnectionFactory;
import com.ibm.hwmca.fw.connmgr.ConnectionGroup;
import com.ibm.hwmca.fw.connmgr.ConnectionManager;
import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.servlet.util.HMCSession;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.tasklet.TaskletConnection;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.tasklet.TaskletRequest;
import com.ibm.hwmca.fw.tasklet.TaskletResponse;
import com.ibm.hwmca.fw.tasklet.impl.TaskletInitialRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlRequest;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.ControlResponse;
import com.ibm.hwmca.fw.tasklet.impl.cntrl.TerminateControlRequest;
import com.ibm.hwmca.fw.tasklet.xport.ConversationComponent;
import com.ibm.hwmca.fw.tasklet.xport.NewConnectionSource;
import com.ibm.hwmca.fw.tasklet.xport.TaskletCommunicationClient;
import com.ibm.hwmca.fw.tasklet.xport.TaskletManager;
import com.ibm.hwmca.fw.tasklet.xport.TaskletNewConnectionParms;
import com.ibm.hwmca.fw.tasklet.xport.monad.MonadConnectionParms;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.fw.util.UUID;
import com.ibm.hwmca.fw.util.UUIDFactory;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class MonadClient
implements TaskletCommunicationClient,
NewConnectionSource {
    private static final String TRACE_MASKT = "XTSKCmCT";
    private static final String TRACE_MASKF = "XTSKCmCF";
    private static final String TRACE_MASKD = "XTSKCmCD";
    private static final String ATTRIBUTE_NAME = "com.ibm.hwmca.fw.tasklet.xport.monad.monadClient.ConnMgrSession";
    private ClientUserContext clientUserContext = null;
    private ConnectionGroup connectionGroup = null;
    private TaskletManager manager;
    private Object connectionsLock = new Object();
    private Map connections = new HashMap();
    private boolean terminate = false;
    protected int traceId = -1;
    protected Integer monadId;
    protected UserContext userContext = null;
    protected boolean clientInitialized = false;
    private static final Hashtable registry = new Hashtable();
    private static int nextMonadId;

    private static final synchronized Integer getNextMonadId() {
        return new Integer(nextMonadId++);
    }

    public static final MonadClient getMonadClient(Integer key) {
        return (MonadClient)registry.get(key);
    }

    protected void finalize() {
        registry.remove(this.monadId);
    }

    public MonadClient(ClientUserContext clientUserContext) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] <init> clientUserContext=" + clientUserContext);
        if (clientUserContext == null) {
            try {
                clientUserContext = ClientUserContext.getUserContext();
            }
            catch (NullContextException e) {
                throw new TaskletException(e);
            }
        }
        this.clientUserContext = clientUserContext;
        this.monadId = MonadClient.getNextMonadId();
        registry.put(this.monadId, this);
    }

    private UserContext formUserContext() throws TaskletException {
        try {
            String userId = this.clientUserContext != null ? this.clientUserContext.getConnectionFactory().getUserName() : ConnectionFactory.getUserConnectionFactory().getUserName();
            InetAddress clientAddress = this.clientUserContext != null ? this.clientUserContext.getAddress() : ConnectionFactory.getUserConnectionFactory().getServerAddress();
            int type = 1;
            UUID uuid = UUIDFactory.generate(4);
            this.userContext = new UserContext(userId, clientAddress, type, uuid, null);
            if (this.clientUserContext != null) {
                this.userContext.setLocales(this.clientUserContext.getLocales());
                this.userContext.setTimeZone(this.clientUserContext.getTimeZone());
            } else {
                this.userContext.setLocales(new Locale[]{Locale.getDefault()});
                this.userContext.setTimeZone(TimeZone.getDefault());
            }
            return this.userContext;
        }
        catch (UnknownHostException e) {
            Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] UnknownHostException attempting to create manager.");
            throw new TaskletException(e);
        }
    }

    public MonadClient() throws TaskletException {
        this(null);
    }

    public boolean isAuthenticated() {
        return true;
    }

    public Connection connect(String name, ConversationComponent initData) throws TaskletException {
        Connection connection;
        Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] connect(" + name + "," + initData + ")");
        try {
            if (this.connectionGroup == null) {
                this.connectionGroup = this.clientUserContext != null ? this.clientUserContext.getConnectionFactory().getConnections("tasklet_LoopBack", 1, new MonadConnectionParms(this.monadId, name, initData)) : ConnectionFactory.getUserConnectionFactory().getConnections("tasklet_LoopBack", 1, new MonadConnectionParms(this.monadId, name, initData));
            }
            connection = this.connectionGroup.getConnections()[0];
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskletConnection accept(String name) {
        Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] accept( " + name + " )");
        Object theConnection = null;
        Object object = this.connectionsLock;
        synchronized (object) {
            while (!this.terminate && this.connections.get(name) == null) {
                try {
                    this.connectionsLock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (!this.terminate) {
                List namedConnections = (List)this.connections.get(name);
                TaskletConnection theNewConnection = (TaskletConnection)namedConnections.remove(0);
                if (namedConnections.isEmpty()) {
                    this.connections.remove(name);
                }
                return theNewConnection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newConnection(Connection connection, Serializable parm) {
        Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] newConnection( " + connection + ", " + parm + " )");
        TaskletNewConnectionParms parms = (TaskletNewConnectionParms)parm;
        Object object = this.connectionsLock;
        synchronized (object) {
            ArrayList<TaskletConnection> namedConnections = (ArrayList<TaskletConnection>)this.connections.get(parms.getName());
            if (namedConnections == null) {
                namedConnections = new ArrayList<TaskletConnection>();
                this.connections.put(parms.getName(), namedConnections);
            }
            namedConnections.add(new TaskletConnection(connection, parms.getInitData()));
            this.connectionsLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskletResponse init(TaskletInitialRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] init(" + request + ")");
        if (this.manager != null) {
            Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] manager exists, cleaning it up.  Probably due to a redirect.");
            TaskletManager theManager = this.manager;
            this.manager = null;
            theManager.terminate();
        }
        try {
            this.manager = (TaskletManager)Class.forName(request.getManagerName()).newInstance();
        }
        catch (ClassNotFoundException e) {
            Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] ClassNotFoundException attempting to create manager.");
            throw new TaskletException(e);
        }
        catch (InstantiationException e) {
            Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] InstantiationException attempting to create manager.");
            Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] cause:");
            Trace.trace(TRACE_MASKF, e.getCause());
            throw new TaskletException(e);
        }
        catch (IllegalAccessException e) {
            Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] IllegalAccessException attempting to create manager.");
            throw new TaskletException(e);
        }
        try {
            HMCSession hmcSession = this.clientUserContext.getHMCSession();
            if (hmcSession != null) {
                ContextId contextId = (ContextId)hmcSession.getSessionAttribute(ATTRIBUTE_NAME);
                if (contextId == null) {
                    this.userContext = this.formUserContext();
                    contextId = ConnectionManager.getManager().getUserConnectionServer().putContext(this.userContext);
                    hmcSession.setSessionAttribute(ATTRIBUTE_NAME, contextId);
                } else {
                    this.userContext = ConnectionManager.getManager().getUserConnectionServer().getContext(contextId);
                }
            } else {
                this.userContext = this.formUserContext();
                ConnectionManager.getManager().getUserConnectionServer().putContext(this.userContext);
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] HException attempting to set context into ConnectionManager.");
            throw new TaskletException(e);
        }
        this.userContext.attachToThread();
        this.manager.setNewConnectionSource(this);
        MonadClient monadClient = this;
        synchronized (monadClient) {
            this.clientInitialized = true;
            this.notifyAll();
        }
        return this.manager.init(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws TaskletException {
        Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] terminate()");
        this.terminate = true;
        this.manager.terminate();
        if (this.connectionGroup != null) {
            this.connectionGroup.closeConnections();
        }
        Object object = this.connectionsLock;
        synchronized (object) {
            this.connectionsLock.notifyAll();
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postControlRequest(ControlRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] postControlRequest(" + request + ")");
        if (request instanceof TerminateControlRequest) {
            this.terminate();
        } else {
            MonadClient monadClient = this;
            synchronized (monadClient) {
                while (!this.clientInitialized && !this.terminate) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.userContext.attachToThread();
            this.manager.postControlRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControlRequest getControlRequest(ControlResponse response) throws TaskletException {
        ControlRequest cr;
        Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] getControlRequest(" + response + ")");
        MonadClient monadClient = this;
        synchronized (monadClient) {
            while (!this.clientInitialized && !this.terminate) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        this.userContext.attachToThread();
        ControlRequest controlRequest = cr = this.manager != null ? this.manager.getControlRequest(response) : null;
        if (this.terminate) {
            return new TerminateControlRequest();
        }
        if (cr instanceof TerminateControlRequest) {
            return null;
        }
        return cr;
    }

    public TaskletResponse request(TaskletRequest request) throws TaskletException {
        Trace.trace(TRACE_MASKF, "[MonadClient:" + this.traceId + "] request(" + request + ")");
        this.userContext.attachToThread();
        return this.manager.request(request);
    }

    public void setTraceId(int traceId) {
        Trace.trace(TRACE_MASKF, "[MonadClient:" + traceId + "] setTraceId(" + traceId + ")");
        this.traceId = traceId;
    }
}

